import { callAdvancedGeminiApi } from './gemini';
import { callLongcatApi } from './longcat';

export async function callAI(prompt, systemPrompt, taskType, settings, onLog, signal) {
    const provider = settings.provider || 'gemini'; // default to gemini

    if (provider === 'longcat') {
        const apiKey = settings.longcatApiKey; // We'll store single key for now
        const model = settings.model; // Use the selected model from settings
        return await callLongcatApi(prompt, systemPrompt, taskType, apiKey, model, onLog, signal);
    } else {
        // Default: Gemini
        // For Gemini, we might have multiple keys in settings.apiKeys
        return await callAdvancedGeminiApi(prompt, systemPrompt, taskType, settings.apiKeys, onLog, signal);
    }
}
